<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Contentwarehouse;

class AssistantApiSettingsLinkedUser extends \Google\Collection
{
  protected $collection_key = 'names';
  /**
   * @var string
   */
  public $castLinkingTime;
  /**
   * @var string
   */
  public $email;
  /**
   * @var string
   */
  public $gaiaId;
  protected $namesType = AppsPeopleOzExternalMergedpeopleapiName::class;
  protected $namesDataType = 'array';
  public $names;

  /**
   * @param string
   */
  public function setCastLinkingTime($castLinkingTime)
  {
    $this->castLinkingTime = $castLinkingTime;
  }
  /**
   * @return string
   */
  public function getCastLinkingTime()
  {
    return $this->castLinkingTime;
  }
  /**
   * @param string
   */
  public function setEmail($email)
  {
    $this->email = $email;
  }
  /**
   * @return string
   */
  public function getEmail()
  {
    return $this->email;
  }
  /**
   * @param string
   */
  public function setGaiaId($gaiaId)
  {
    $this->gaiaId = $gaiaId;
  }
  /**
   * @return string
   */
  public function getGaiaId()
  {
    return $this->gaiaId;
  }
  /**
   * @param AppsPeopleOzExternalMergedpeopleapiName[]
   */
  public function setNames($names)
  {
    $this->names = $names;
  }
  /**
   * @return AppsPeopleOzExternalMergedpeopleapiName[]
   */
  public function getNames()
  {
    return $this->names;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(AssistantApiSettingsLinkedUser::class, 'Google_Service_Contentwarehouse_AssistantApiSettingsLinkedUser');
